////////////////////////////////////////////////
//
//     -- Mikael Beckius 2009 --
//
////////////////////////////////////////////////

#ifndef _CUBE_VIEW_H_
#define _CUBE_VIEW_H_

#include <coecntrl.h>
#include <aknappui.h>
#include <akndoc.h>
#include <aknapp.h>
#include <egl\egl.h>
#include <egl\eglext.h>
#include <gles\gl.h>
#include <gles\glext.h>
												 
const TUid KUidCube={0xA06C5598};

// Number of digits required to hold the maximum length checksum
const TInt KMaxChecksumLength=10; 

class CTestTimer : public CTimer{
public:
	static CTestTimer* NewL();
	void Start(TTimeIntervalMicroSeconds32 aDelay,TTimeIntervalMicroSeconds32 anInterval,TCallBack aCallBack);
	virtual ~CTestTimer();
protected:
	CTestTimer();
	virtual void RunL();
private:
	TTimeIntervalMicroSeconds32 iInterval;
	TCallBack iCallBack;
};

class CCubeView : public CCoeControl {
public:
	static CCubeView* NewL(const TRect& rect);
	void ConstructL(const TRect& rect);
	
	TKeyResponse OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType);
	void HandlePointerEventL(const TPointerEvent& aPointerEvent);

	static TInt DrawCallback(TAny* aInstance);

	void draw();

	virtual ~CCubeView();

private:
	void Draw(const TRect& rect) const;
	TTime				 iBeginTime;
	TTime				 iEndTime;

	EGLDisplay   iDpy;
	EGLSurface   iDraw;
	EGLContext	 iCtx;
	CTestTimer*	 iPeriodic;
	CFbsBitmap*  iBitmap;
	void*        iBitmapAddress;
  int          iTestCase;
	unsigned		 iFrame;
	bool         iRender;
	unsigned int iId;
	unsigned int m_program;
};

class CCubeAppUi : public CAknAppUi{
public:
	~CCubeAppUi();

public:
	void ConstructL();
	
private:
	virtual void HandleCommandL(TInt aCommand);
	virtual void HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination);

private:
	CCubeView *iView;
};

class CCubeDocument : public CAknDocument{
public:
	static CCubeDocument* NewL(CEikApplication& aApp);
	CCubeDocument(CEikApplication& aApp);
	~CCubeDocument();

private:
	CAknAppUi* CreateAppUiL();
};


class CCubeApplication : public CAknApplication {
private:
	TUid          AppDllUid() const;

	CApaDocument* CreateDocumentL();
};

#endif
