////////////////////////////////////////////////
//
//     -- Mikael Beckius 2009 --
//
////////////////////////////////////////////////

#include <reent.h>
#include <eikenv.h>
#include <e32cmn.h>

#include "bectech256x256.h"
#include "CubeView.h"

#include <CubeS60.rsg>

#ifndef GL_BGRA
#define GL_BGRA  0x80E1
#endif

static float vertices[] = {
	0, 0, 1.0f,   25, 25, 25,  0, 0, 1.0f, -25, 25, 25,  0, 0, 1.0f,  25,-25, 25,  0, 0, 1.0f,  -25,-25, 25, // front
		0, 0,-1.0f,  -25, 25,-25,  0, 0,-1.0f,  25, 25,-25,  0, 0,-1.0f, -25,-25,-25,  0, 0,-1.0f,  25,-25,-25,  // back
		-1.0f, 0, 0, -25, 25, 25, -1.0f, 0, 0, -25, 25,-25, -1.0f, 0, 0, -25,-25, 25, -1.0f, 0, 0,  -25,-25,-25, // left
		1.0f, 0, 0,   25, 25,-25,  1.0f, 0, 0,  25, 25, 25,  1.0f, 0, 0,  25,-25,-25,  1.0f, 0, 0,   25,-25, 25, // right
		0, 1.0f, 0,   25, 25,-25,  0, 1.0f, 0, -25, 25,-25,  0, 1.0f, 0,  25, 25, 25,  0, 1.0f, 0,  -25, 25, 25, // top
		0,-1.0f, 0,   25,-25, 25,  0,-1.0f, 0, -25,-25, 25,  0, -1.0f, 0, 25,-25,-25,  0, -1.0f, 0, -25,-25,-25  // bottom
}; 

static float textureCoords[] = {
	1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1 
};

static short g_indices[24] =  {
	0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15, 16,17,18,19, 20,21,22,23
};

CTestTimer *CTestTimer::NewL(){
	CTestTimer* timer = new(ELeave)CTestTimer;
	CleanupStack::PushL(timer);
	timer->ConstructL();
	CleanupStack::Pop();
	return timer;
	}

CTestTimer::CTestTimer() : CTimer(CActive::EPriorityIdle){
	CActiveScheduler::Add(this);
}


CTestTimer::~CTestTimer(){

}

void CTestTimer::Start(TTimeIntervalMicroSeconds32 aDelay,TTimeIntervalMicroSeconds32 anInterval,TCallBack aCallBack){
	iInterval=anInterval.Int();
	iCallBack=aCallBack;
	HighRes(aDelay);
}

void CTestTimer::RunL()
{
	HighRes(iInterval);
	iCallBack.CallBack();
}

CCubeView* CCubeView::NewL(const TRect& aRect){
	CCubeView* cmv = new(ELeave)CCubeView;
	CleanupStack::PushL(cmv);
	cmv->ConstructL(aRect);
	CleanupStack::Pop();
	return cmv;
}

CCubeView::~CCubeView(){
	delete iPeriodic;
	eglMakeCurrent(iDpy,0,0,0);
	eglDestroyContext(iDpy,iCtx);
	eglDestroySurface(iDpy,iDraw);
	eglTerminate(iDpy);
}

void CCubeView::ConstructL(const TRect& aRect){
	RDebug::Printf("CCubeView::ConstructL\n");
	TRAPD(error,CreateWindowL());
	if(error){
		// Something is wrong, but basically I just dislike warnings!
	}

	TRect rect(20,20,220,220);
	SetRect(rect);
	SetExtentToWholeScreen();

	int minor = 0;
	int major = 0;
	EGLint numConfigs = 0;

	EGLConfig   cfg;

	EGLint attrib[] = {
		EGL_SURFACE_TYPE,EGL_WINDOW_BIT,
			EGL_RED_SIZE,8,
			EGL_GREEN_SIZE,8,
			EGL_BLUE_SIZE,8,
			EGL_ALPHA_SIZE,8,
			EGL_DEPTH_SIZE,16,
			EGL_NONE
	};

	iDpy = eglGetDisplay(EGL_DEFAULT_DISPLAY);

	if(!iDpy){
		RDebug::Printf("Failed to open the EGL default display");
	}

	if(!eglInitialize(iDpy,&major,&minor)){
		RDebug::Printf("Failed to init the EGL default display");
	}

	if(!eglChooseConfig(iDpy,attrib,&cfg,1,&numConfigs)||(numConfigs<1)){
		RDebug::Printf("Failed to find a config on the EGL default display");
	}

	iCtx = eglCreateContext(iDpy,cfg,0,0);
	if(!iCtx){
		RDebug::Printf("Failed to create a context");
	}

	// iDraw = eglCreateWindowSurface(iDpy,cfg,DrawableWindow(),0);
	iDraw = eglCreateWindowSurface(iDpy,cfg,&Window(),0);
	if(!iDraw){
		RDebug::Printf("Failed to create a context");
	}

	if(!eglMakeCurrent(iDpy,iDraw,iDraw,iCtx)){
		RDebug::Printf("Failed to make the context current");
	}

	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	glEnable(GL_DEPTH_TEST); 
	glDepthFunc(GL_LEQUAL);

	glShadeModel(GL_SMOOTH);

	glEnableClientState(GL_VERTEX_ARRAY);
	// glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glEnableClientState(GL_NORMAL_ARRAY);

	glTexCoordPointer(2,GL_FLOAT,0,textureCoords);
	glNormalPointer(GL_FLOAT,24,vertices);
	glVertexPointer(3,GL_FLOAT,24,vertices+3);

	glEnable(GL_TEXTURE_2D);	

	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	glEnable(GL_NORMALIZE);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE,GL_TRUE);

	glClearColor(0.0f,0.0f,1.0f,1.0f);

	GLfloat spec[] = {0.5f,0.5f,0.5f,0.5f};
	GLfloat amb[] = {0.05f,0.05f,0.05f,1.0f};
	GLfloat dif[] = {0.9f,0.9f,0.9f,1.0f};
	GLfloat lightPos[] = {-1.0f,0.0f,10.0f,0.0f};

	glLightfv(GL_LIGHT0,GL_AMBIENT, amb);
	glLightfv(GL_LIGHT0,GL_SPECULAR, spec);
	glLightfv(GL_LIGHT0,GL_DIFFUSE, dif);
	glLightfv(GL_LIGHT0,GL_POSITION,lightPos);

	float specular[] = {0.9f, 0.9f, 0.9f,1.0f};
	float diffuse[] = {0.8f, 0.8f, 0.8f, 1.0f};
	float ambient[] = {0.16f, 0.16f, 0.16f, 0.5f};

	glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,specular);
	glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,diffuse);
	glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,ambient);
	glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,108.0f);

	GLuint id;
	glGenTextures(1,&id);
	glBindTexture(GL_TEXTURE_2D,id);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	// Nokia does not support BGRA even though it is the native format of Symbian
	// glTexImage2D(GL_TEXTURE_2D,0,GL_BGRA,256,256,0,GL_BGRA,GL_UNSIGNED_BYTE,imageBectech);
	glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,256,256,0,GL_RGBA,GL_UNSIGNED_BYTE,imageBectech);
	ActivateL();

	iPeriodic = CTestTimer::NewL();
  iPeriodic->Start(0,10,TCallBack(CCubeView::DrawCallback,this));
}

void CCubeView::draw(){
	int width=Rect().Width();
	int height=Rect().Height();

	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glViewport(0,0,width,height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrthof(-width/2,width/2,-height/2,height/2,-100.0,100.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glRotatef(iFrame/2,0,1,0);
	glRotatef(iFrame,1,0,0);
	glScalef(1.75f,1.75f,1.75f);

	for(int i=0;i<24;i+=4)
		glDrawElements(GL_TRIANGLE_STRIP,4,GL_UNSIGNED_SHORT,g_indices+i);

	eglSwapInterval(iDpy,0);
	eglSwapBuffers(iDpy,iDraw);
}

TInt CCubeView::DrawCallback(TAny* aInstance){
	CCubeView* instance = (CCubeView*)aInstance;
	instance->draw();

	if(!(instance->iFrame%900)){
		User::ResetInactivityTime();
		TBuf<32> buf;
		instance->iEndTime.UniversalTime();
		buf.Format(_L("%f Hz"),900000000.0/(float)(instance->iEndTime.Int64()-instance->iBeginTime.Int64()));
		RDebug::Printf("Frame time: %f",900000000.0/(float)(instance->iEndTime.Int64()-instance->iBeginTime.Int64()));
		User::InfoPrint(buf);			
		instance->iBeginTime.UniversalTime();
	}
	instance->iFrame++;
	return 0;
}

void CCubeView::Draw(const TRect& aRect) const{
	RDebug::Printf("CRCTestView::Draw\n");
	// TRgb color(0,128);
	// CWindowGc& gc = SystemGc();
	// gc.DrawRect(aRect);
}

TKeyResponse CCubeView::OfferKeyEventL(const TKeyEvent& aKeyEvent,TEventCode aType){
	TBuf<32> buf;

	if(aType == EEventKeyDown) {
		RDebug::Printf("Key code: %d",aKeyEvent.iScanCode);
		switch (aKeyEvent.iScanCode){
		case 'R':
			return EKeyWasConsumed;
		case 'S':
			SetExtentToWholeScreen();
			return EKeyWasConsumed;
		case 'J':
		case '4':
			SetRect(TRect(20,20,220,220));
			RDebug::Printf("SetRect 4");
			return EKeyWasConsumed;
		case 'T':
		case '7':
			SetExtentToWholeScreen();
	  	return EKeyWasConsumed;
		case 'Q':
		case 167:
		case 172:
		case 212:
		case 213:
		case '8':
			CBaActiveScheduler::Exit();
		}
	}
	return EKeyWasNotConsumed;
}

void CCubeView::HandlePointerEventL(const TPointerEvent& aPointerEvent){
	if(aPointerEvent.iType == TPointerEvent::EButton1Down)
	{
		CBaActiveScheduler::Exit();
	}
}


void CCubeAppUi::ConstructL(){

	BaseConstructL();
	// BaseConstructL(EAppOrientationLandscape);
	iView=CCubeView::NewL(ClientRect());
	AddToStackL(iView);
}


CCubeAppUi::~CCubeAppUi(){
	RemoveFromStack(iView);
	delete iView;
}

void CCubeAppUi::HandleCommandL(TInt aCommand){
	switch (aCommand){
		// case EEikCmdGoBack:
		//	 CEikAppUi::Exit();
		//	 break;
	case EEikCmdExit: 
		CEikAppUi::Exit();
		break;
	default:
		break;
	}
}

void CCubeAppUi::HandleWsEventL(const TWsEvent& aEvent,CCoeControl* aDestination){
	RDebug::Printf("TWsEvent %d",aEvent.Type());
	switch (aEvent.Type())
	{
	case EEventFocusLost:
		// iView->Stop();
		break;
	case EEventFocusGained:
		// iView->Start();
		break;
	default:
		break;
	}
	CAknAppUi::HandleWsEventL(aEvent, aDestination);
}

CCubeDocument::CCubeDocument(CEikApplication& aApp) : CAknDocument(aApp){

}

CCubeDocument::~CCubeDocument(){

}

CCubeDocument* CCubeDocument::NewL(CEikApplication& aApp){
	CCubeDocument* self=new(ELeave) CCubeDocument(aApp);
	return self;
}

CAknAppUi* CCubeDocument::CreateAppUiL(){
	return(new(ELeave) CCubeAppUi);
}

TUid CCubeApplication::AppDllUid() const{
	return(KUidCube);
}

CApaDocument* CCubeApplication::CreateDocumentL(){
	return CCubeDocument::NewL(*this);
}
