////////////////////////////////////////////////
//
//     -- Mikael Beckius 2009 --
//
////////////////////////////////////////////////

#include <e32cmn.h>
#include <e32debug.h>
#include <gles\egl.h>
#include <gles\gl.h>

#include "bectech256x256.h"

#ifndef GL_BGRA
#define GL_BGRA  0x80E1
#endif

static float vertices[] = {
	0, 0, 1.0f,   25, 25, 25,  0, 0, 1.0f, -25, 25, 25,  0, 0, 1.0f,  25,-25, 25,  0, 0, 1.0f,  -25,-25, 25, // front
		0, 0,-1.0f,  -25, 25,-25,  0, 0,-1.0f,  25, 25,-25,  0, 0,-1.0f, -25,-25,-25,  0, 0,-1.0f,  25,-25,-25,  // back
		-1.0f, 0, 0, -25, 25, 25, -1.0f, 0, 0, -25, 25,-25, -1.0f, 0, 0, -25,-25, 25, -1.0f, 0, 0,  -25,-25,-25, // left
		1.0f, 0, 0,   25, 25,-25,  1.0f, 0, 0,  25, 25, 25,  1.0f, 0, 0,  25,-25,-25,  1.0f, 0, 0,   25,-25, 25, // right
		0, 1.0f, 0,   25, 25,-25,  0, 1.0f, 0, -25, 25,-25,  0, 1.0f, 0,  25, 25, 25,  0, 1.0f, 0,  -25, 25, 25, // top
		0,-1.0f, 0,   25,-25, 25,  0,-1.0f, 0, -25,-25, 25,  0, -1.0f, 0, 25,-25,-25,  0, -1.0f, 0, -25,-25,-25  // bottom
}; 

static float textureCoords[] = {
	1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1,
		1, 0, 0, 0, 1, 1, 0, 1 
};

static short g_indices[24] =  {
	0,1,2,3, 4,5,6,7, 8,9,10,11, 12,13,14,15, 16,17,18,19, 20,21,22,23
};

int main(int args,char** argv){
	unsigned frame = 0;
	TTime beginTime;
	TTime endTime;
	EGLDisplay dpy;
	EGLSurface surface;
	EGLContext context;
	EGLConfig configs[1];
	EGLint config_count;
	EGLint major, minor; 
	EGLint attribs[] = {
		EGL_SURFACE_TYPE,EGL_WINDOW_BIT,
			EGL_RED_SIZE,8,
			EGL_GREEN_SIZE,8,
			EGL_BLUE_SIZE,8,
			EGL_ALPHA_SIZE,8,
			EGL_DEPTH_SIZE,16,
			EGL_NONE
	};

	int width=360; // Hmta frn HAL!!
	int height=640;

	dpy = eglGetDisplay (EGL_DEFAULT_DISPLAY);
	eglInitialize(dpy, &major, &minor);
	eglGetConfigs (dpy, configs, 1, &config_count);
	eglChooseConfig (dpy, attribs, configs, 1, &config_count);
	surface = eglCreateWindowSurface (dpy, configs[0], 0, 0);
	context = eglCreateContext (dpy, configs[0], EGL_NO_CONTEXT, 0);
	eglMakeCurrent (dpy, surface, surface, context);

	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	glEnable(GL_DEPTH_TEST); 
	glDepthFunc(GL_LEQUAL);

	glShadeModel(GL_SMOOTH);

	glEnableClientState(GL_VERTEX_ARRAY);
	// glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	glEnableClientState(GL_NORMAL_ARRAY);

	glTexCoordPointer(2,GL_FLOAT,0,textureCoords);
	glNormalPointer(GL_FLOAT,24,vertices);
	glVertexPointer(3,GL_FLOAT,24,vertices+3);

	glEnable(GL_TEXTURE_2D);	

	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

	glEnable(GL_NORMALIZE);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE,GL_TRUE);

	GLfloat spec[] = {0.5f,0.5f,0.5f,0.5f};
	GLfloat amb[] = {0.05f,0.05f,0.05f,1.0f};
	GLfloat dif[] = {0.9f,0.9f,0.9f,1.0f};
	GLfloat lightPos[] = {-6.0f,0.0f,60.0f,0.0f};

	glLightfv(GL_LIGHT0,GL_AMBIENT, amb);
	glLightfv(GL_LIGHT0,GL_SPECULAR, spec);
	glLightfv(GL_LIGHT0,GL_DIFFUSE, dif);
	glLightfv(GL_LIGHT0,GL_POSITION,lightPos);

	float specular[] = {0.9f, 0.9f, 0.9f,1.0f};
	float diffuse[] = {0.8f, 0.8f, 0.8f, 1.0f};
	float ambient[] = {0.16f, 0.16f, 0.16f, 0.5f};

	glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,specular);
	glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,diffuse);
	glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,ambient);
	glMaterialf(GL_FRONT_AND_BACK,GL_SHININESS,108.0f);

	GLuint id;
	glGenTextures(1,&id);
	glBindTexture(GL_TEXTURE_2D,id);
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	// Nokia does not support BGRA even though it is the native format of Symbian
	// glTexImage2D(GL_TEXTURE_2D,0,GL_BGRA,256,256,0,GL_BGRA,GL_UNSIGNED_BYTE,imageBectech);
	glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,256,256,0,GL_RGBA,GL_UNSIGNED_BYTE,imageBectech);

	while(++frame<4500){
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	glViewport(0,0,width,height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrthof(-width/2,width/2,-height/2,height/2,-100.0,100.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glRotatef(frame/2,0,1,0);
	glRotatef(frame,1,0,0);
	glScalef(1.75f,1.75f,1.75f);

	for(int i=0;i<24;i+=4)
		glDrawElements(GL_TRIANGLE_STRIP,4,GL_UNSIGNED_SHORT,g_indices+i);
		eglSwapInterval(dpy,0);
		eglSwapBuffers(dpy,surface);
		if(!(frame%100)){
			endTime.UniversalTime();
			double time = (double)(endTime.Int64()-beginTime.Int64())/1000000.0;
			RDebug::Printf("%f Hz",100.0/time);
			beginTime.UniversalTime();
		}
	}
	eglDestroyContext (dpy, context);
	eglDestroySurface (dpy, surface);
	eglMakeCurrent (dpy, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
	eglTerminate (dpy);
	return 0;
}


