////////////////////////////////////////////////
//
//	--	Mikael Beckius 2008	--
//
////////////////////////////////////////////////

#ifdef OPENGL
#ifdef VERTEX_SHADER
uniform vec4 mMaterialAmbientColor = vec4(0.1,0.1,0.1,1);		// Material's	ambient	color
uniform vec4 mMaterialDiffuseColor = vec4(0.8,0.8,0.8,1);		// Material's	diffuse	color
uniform vec4 mMaterialSpecularColor = vec4(1.0,1.0,1.0,1);	// Material's	specular color

uniform vec3 mLightPos = vec3(0.0f,0.0f,200.0f);
uniform float mTime = 0.0f;

const float k = 3.1415926535897932384626433832795/51.5f;

void main()
{
	vec4 vertex = vec4(gl_Vertex.x,gl_Vertex.y,20.8f*sin(k*(gl_Vertex.x+mTime))*sin(k*(gl_Vertex.y+mTime)),gl_Vertex.w);
	vec3 ds = vec3(1.0f,0.0f,-20.8f*k*sin(k*(gl_Vertex.y+mTime))*cos(k*(gl_Vertex.x+mTime)));
	vec3 dt = vec3(0.0f,1.0f,20.8f*k*cos(k*(gl_Vertex.y+mTime))*sin(k*(gl_Vertex.x+mTime)));
	vec3 normal = cross(ds,dt);

	vec3 eyePosition = (gl_ModelViewMatrix * vertex).xyz; 
	vec3 lightVec = normalize(mLightPos-eyePosition);
	vec3 eyeNormal = normalize(gl_NormalMatrix * normal);
	vec3 reflectVec = reflect( -lightVec, eyeNormal);
	vec3 diffuse = max(dot(lightVec,eyeNormal),0.0) * mMaterialDiffuseColor.rgb;
	vec3 specular = pow(max(dot(reflectVec,normalize(-eyePosition)), 0.0),32.0) * mMaterialSpecularColor.rgb;

	gl_FrontColor = vec4(diffuse + specular, 1.0);
	gl_Position = gl_ModelViewProjectionMatrix * vertex;
	gl_TexCoord[0] = vec4(gl_MultiTexCoord0.s-mTime/100,gl_MultiTexCoord0.t-mTime/100,0,0);
}
#elif FRAGMENT_SHADER
uniform sampler2D tex0;

void main()
{
	gl_FragColor = gl_Color*texture2D(tex0,gl_TexCoord[0].xy);
}
#elif GEOMTERY_SHADER


#endif

#else

#endif
