////////////////////////////////////////////////
//
//		 --	Mikael Beckius 2005	--
//
////////////////////////////////////////////////
#version 120

uniform vec4 mMaterialAmbientColor;		// Material's	ambient	color
uniform vec4 mMaterialDiffuseColor;		// Material's	diffuse	color
uniform vec4 mMaterialSpecularColor;	// Material's	specular color

uniform vec4 mLightDiffuse;						// Light's diffuse color
uniform vec4 mLightAmbient;						// Light's ambient color

uniform vec3 mLightPos;

// float4x4 mWorld;										// World matrix	for	object
// float4x4 mWorldViewProj;						// World * View	*	Projection transformation

/*
void main(){
	vec3 lightVec;
	vec3 normalVec = gl_NormalMatrix * gl_Normal;
	gl_Position = gl_ModelViewMatrix * gl_Vertex;
		
	lightVec=normalize(mLightPos-gl_Position.xyz);
	// lightVec=normalize(gl_LightSource[0].position.xyz-gl_Position.xyz);
	vec3 diffuse = mLightDiffuse.rgb*max(dot(lightVec,normalVec),0.0);

	gl_FrontColor.rgb = mMaterialDiffuseColor.rgb*diffuse+mMaterialAmbientColor.rgb*mLightAmbient.rgb;
	gl_FrontColor.a = 1.0;
	gl_Position = gl_ProjectionMatrix * gl_Position;
	gl_TexCoord[0] = gl_MultiTexCoord0;	
}
*/

void main()
{
	vec3 eyePosition = (gl_ModelViewMatrix * gl_Vertex).xyz; 
	vec3 lightVec = normalize(mLightPos-eyePosition);
	vec3 eyeNormal = normalize(gl_NormalMatrix * gl_Normal);
	vec3 reflectVec = reflect( -lightVec, eyeNormal);
	vec3 diffuse = max(dot(lightVec,eyeNormal),0.0) * mMaterialDiffuseColor.rgb;
	vec3 specular = pow(max(dot(reflectVec,normalize(-eyePosition)), 0.0),32.0) * mMaterialSpecularColor.rgb;

	gl_FrontColor = vec4(diffuse + specular, 1.0);
	gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	gl_TexCoord[0] = gl_MultiTexCoord0;
}
