/*
 * Decompiled with CFR 0.152.
 */
package cubebec.test;

import com.sun.opengl.util.Animator;
import cubebec.CubeObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CubeWindow
extends JFrame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private CubeCanvas cubeCanvas;
    private CubeObject cubeObject = new CubeObject();
    private Animator animator;

    public CubeWindow() {
        super("Mikael Beckius");
        this.cubeCanvas = new CubeCanvas(this.cubeObject);
        GLCanvas canvas = this.cubeCanvas.getGLCanvas();
        canvas.addKeyListener(this);
        canvas.requestFocus();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)canvas, "Center");
        this.add(panel);
        this.animator = new PeriodicAnimator(this.cubeCanvas.getGLCanvas());
        this.animator.start();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private static class CubeCanvas
    implements GLEventListener {
        private GLCanvas glCanvas = null;
        private GLCapabilities glCaps = new GLCapabilities();
        private CubeObject cubeObject;

        public CubeCanvas(CubeObject cubeObject) {
            this.glCanvas = new GLCanvas(this.glCaps);
            this.glCanvas.addGLEventListener(this);
            this.cubeObject = cubeObject;
        }

        public GLCanvas getGLCanvas() {
            return this.glCanvas;
        }

        @Override
        public void init(GLAutoDrawable drawable) {
            this.cubeObject.init(drawable);
        }

        @Override
        public void display(GLAutoDrawable drawable) {
            GL gl = drawable.getGL();
            gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            gl.glClear(16640);
            this.cubeObject.display(drawable);
        }

        @Override
        public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
        }

        @Override
        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            this.cubeObject.reshape(drawable, x, y, width, height);
        }
    }

    private static class PeriodicAnimator
    extends Animator {
        public PeriodicAnimator(GLAutoDrawable drawable) {
            super(drawable);
        }

        @Override
        protected void display() {
            super.display();
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

