/*
 * Decompiled with CFR 0.152.
 */
package graphicsUtils;

import graphicsUtils.ImageLoader;
import java.io.IOException;
import java.io.InputStream;
import util.mbStream;

public class ImageLoaderTGA
extends ImageLoader {
    public byte[] getColorData(byte[] chunk) {
        int dataIndex = 0;
        if (this.m_chunk[2] == 2) {
            int texFormat;
            int imageSize;
            this.m_width = this.m_chunk[12] + this.m_chunk[13] * 256;
            this.m_height = this.m_chunk[14] + this.m_chunk[15] * 256;
            byte pixelSize = this.m_chunk[16];
            System.out.printf("Image type: %d\n", this.m_chunk[2]);
            System.out.printf("Color map: %d\n", this.m_chunk[1]);
            System.out.printf("Pixel size: %d\n", pixelSize);
            System.out.printf("Width: %d\n", this.m_width);
            System.out.printf("Height: %d\n", this.m_height);
            switch (pixelSize) {
                case 16: {
                    imageSize = this.m_height * this.m_width * 2;
                    texFormat = 24;
                    break;
                }
                case 24: {
                    imageSize = this.m_height * this.m_width * 3;
                    texFormat = 24;
                    break;
                }
                default: {
                    imageSize = this.m_height * this.m_width * 4;
                    texFormat = 32;
                }
            }
            if (this.m_chunk[1] == 0) {
                dataIndex = 18 + this.m_chunk[0];
            } else {
                System.out.printf("Colormap not implemented....\n", new Object[0]);
            }
            byte[] texData = new byte[this.m_chunk.length - dataIndex];
            System.arraycopy(this.m_chunk, dataIndex, texData, 0, texData.length);
            if (texFormat == 24) {
                for (int i = 0; i < imageSize; i += 3) {
                    byte c = texData[i];
                    texData[i] = texData[i + 2];
                    texData[i + 2] = c;
                }
            } else if (texFormat == 32) {
                for (int i = 0; i < imageSize; i += 4) {
                    texData[i + 3] = -1;
                }
            }
            return texData;
        }
        System.out.printf("Unsupported format, only 24-bit RGB and 32-bit RGBA supported so far: %d\n", this.m_chunk[2]);
        return null;
    }

    @Override
    public byte[] getColorData(String name) {
        mbStream stream = new mbStream(name.toCharArray(), 5);
        if (stream.error() == 1) {
            System.out.printf("Missing data...\n", new Object[0]);
            return null;
        }
        this.m_chunk = new byte[(int)stream.size()];
        stream.readChunk(this.m_chunk, this.m_chunk.length);
        stream.close();
        return this.getColorData(this.m_chunk);
    }

    public byte[] getColorDataJar(String name) {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(name);){
            int read;
            this.m_chunk = new byte[inputStream.available()];
            int offset = 0;
            while ((read = inputStream.read(this.m_chunk, offset, this.m_chunk.length)) != -1 && (offset += read) < this.m_chunk.length) {
            }
        }
        catch (IOException ex) {
            System.out.printf("Missing data... %s\n", ex.toString());
            return null;
        }
        return this.getColorData(this.m_chunk);
    }
}

