/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import java.util.Iterator;

public class vector<T>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = 5114385613010219331L;
    public static final int _defaultCapacity = 16;
    private Object[] m_array = null;
    private int _capacity;
    private int _arraySize;

    public vector() {
        this(0);
    }

    public vector(int size) {
        this._capacity = 0;
        this._arraySize = 0;
        if (size != 0) {
            this._capacity = size;
            this._allocate();
        }
    }

    public vector(vector<T> v) {
        this._capacity = v._capacity;
        this._arraySize = v.size();
        if (this._arraySize != 0) {
            this._allocate();
        }
        System.arraycopy(v.m_array, 0, this.m_array, 0, this._arraySize);
    }

    public void push_back(T data) {
        if (this._arraySize == this._capacity) {
            this._allocate();
        }
        this.m_array[this._arraySize] = data;
        ++this._arraySize;
    }

    public T pop_back() {
        --this._arraySize;
        return (T)this.m_array[this._arraySize];
    }

    public int size() {
        return this._arraySize;
    }

    public int begin() {
        return 0;
    }

    public int end() {
        return this._arraySize - 1;
    }

    public T erase(int i) {
        Object data = this.m_array[i];
        int blockSize = this._arraySize - i - 1;
        if (blockSize > 0) {
            for (int j = i; j < this._arraySize - 1; ++j) {
                this.m_array[i] = this.m_array[i + 1];
            }
        }
        this.m_array[this._arraySize--] = null;
        return (T)data;
    }

    public void clear() {
        for (int i = 0; i < this._arraySize; ++i) {
            this.m_array[i] = null;
        }
        this._arraySize = 0;
    }

    public void add(int i, T data) {
        this.m_array[i] = data;
    }

    public T elementAt(int i) {
        return (T)this.m_array[i];
    }

    public vector<T> addAll(vector<T> v) {
        if (this != v) {
            if (v.size() <= this._capacity) {
                System.arraycopy(v.m_array, 0, this.m_array, 0, this._arraySize);
                this._arraySize = v.size();
            } else {
                this._capacity = v._capacity;
                this._arraySize = v.size();
                this._allocate();
                System.arraycopy(v.m_array, 0, this.m_array, 0, this._arraySize);
            }
        }
        return this;
    }

    protected final void _allocate() {
        if (this.m_array != null) {
            Object[] tmpArr = this.m_array;
            int newCap = this._capacity + this._capacity;
            this.m_array = new Object[newCap];
            System.arraycopy(tmpArr, 0, this.m_array, 0, this._arraySize);
            this._capacity = newCap;
        } else {
            if (this._capacity == 0) {
                this._capacity = 16;
            }
            this.m_array = new Object[this._capacity];
        }
    }

    protected void _copy(int i) {
    }

    @Override
    public Iterator<T> iterator() {
        return new vectorIterator();
    }

    private class vectorIterator
    implements Iterator<T> {
        int current = 0;
        int lastRet = -1;

        private vectorIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current != vector.this.size();
        }

        @Override
        public T next() {
            return vector.this.elementAt(this.current++);
        }

        @Override
        public void remove() {
            vector.this.erase(this.current);
        }
    }
}

