/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.mbVec3;

public class mbVec4 {
    public float x;
    public float y;
    public float z;
    public float w;

    public mbVec4() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public mbVec4(float xx, float yy, float zz, float ww) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
        this.w = ww;
    }

    public mbVec4(mbVec4 v) {
        this(v.x, v.y, v.z, v.w);
    }

    public mbVec4(float[] v) {
        this(v[0], v[1], v[2], v[3]);
    }

    public mbVec4 clone() {
        return new mbVec4(this.x, this.y, this.z, this.w);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public float magnitude() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public float dot(mbVec4 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z + this.w * v.w;
    }

    public mbVec3 cross(mbVec4 v) {
        return new mbVec3(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public mbVec4 normalize() {
        float invl = 1.0f / this.length();
        this.x *= invl;
        this.y *= invl;
        this.z *= invl;
        this.w *= invl;
        return this;
    }

    public void setLength(float r) {
        this.normalize();
        this.x *= r;
        this.y *= r;
        this.z *= r;
        this.w *= r;
    }

    public mbVec4 add(mbVec4 v) {
        return new mbVec4(this.x + v.x, this.y + v.y, this.z + v.z, this.w + v.w);
    }

    public mbVec4 subtr(mbVec4 v) {
        return new mbVec4(this.x - v.x, this.y - v.y, this.z - v.z, this.w - v.w);
    }

    public mbVec4 mult(float k) {
        return new mbVec4(this.x * k, this.y * k, this.z * k, this.w * k);
    }

    public mbVec4 div(float k) {
        return new mbVec4(this.x / k, this.y / k, this.z / k, this.w / k);
    }

    public float[] array() {
        float[] v = new float[]{this.x, this.y, this.z, this.w};
        return v;
    }
}

