/*
 * Decompiled with CFR 0.152.
 */
package util;

public class mbVec3 {
    public float x;
    public float y;
    public float z;

    public mbVec3() {
        this(0.0f, 0.0f, 0.0f);
    }

    public mbVec3(float xx, float yy, float zz) {
        this.x = xx;
        this.y = yy;
        this.z = zz;
    }

    public mbVec3(mbVec3 v) {
        this(v.x, v.y, v.z);
    }

    public mbVec3(float[] v) {
        this(v[0], v[1], v[2]);
    }

    public mbVec3 clone() {
        return new mbVec3(this.x, this.y, this.z);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float magnitude() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float dot(mbVec3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public mbVec3 cross(mbVec3 v) {
        return new mbVec3(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public mbVec3 normalize() {
        float invl = 1.0f / this.length();
        this.x *= invl;
        this.y *= invl;
        this.z *= invl;
        return this;
    }

    public void setLength(float r) {
        this.normalize();
        this.x *= r;
        this.y *= r;
        this.z *= r;
    }

    public mbVec3 add(mbVec3 v) {
        return new mbVec3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public mbVec3 sub(mbVec3 v) {
        return new mbVec3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public mbVec3 mul(float k) {
        return new mbVec3(this.x * k, this.y * k, this.z * k);
    }

    public mbVec3 div(float k) {
        return new mbVec3(this.x / k, this.y / k, this.z / k);
    }

    public float[] array() {
        float[] v = new float[]{this.x, this.y, this.z};
        return v;
    }
}

