/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class mbStack<T>
implements Iterable<T> {
    private Object[] m_stack;
    private int m_stackPointer = 0;
    private int m_stackSize = 100;

    public mbStack() {
        this.m_stack = new Object[this.m_stackSize];
    }

    public mbStack(int size) {
        this.m_stack = new Object[size];
        this.m_stackSize = size;
    }

    public int size() {
        return this.m_stackPointer;
    }

    public void clear() {
        this.m_stackPointer = 0;
    }

    public void push(T data) {
        if (this.m_stackPointer == this.m_stackSize) {
            System.out.println("Stack is full!");
        } else {
            this.m_stack[this.m_stackPointer] = data;
            ++this.m_stackPointer;
        }
    }

    public T pop() throws NoSuchElementException {
        if (this.m_stackPointer == 0) {
            throw new NoSuchElementException();
        }
        --this.m_stackPointer;
        return (T)this.m_stack[this.m_stackPointer];
    }

    public T top() throws NoSuchElementException {
        if (this.m_stackPointer == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.m_stack[this.m_stackPointer - 1];
    }

    @Override
    public Iterator<T> iterator() {
        return new stackIterator();
    }

    private class stackIterator
    implements Iterator<T> {
        private stackIterator() {
        }

        @Override
        public boolean hasNext() {
            return mbStack.this.size() > 0;
        }

        @Override
        public T next() {
            return mbStack.this.pop();
        }

        @Override
        public void remove() {
        }
    }
}

