/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.mbStream;

class mbParser {
    protected long m_size = 0L;
    protected int m_error = 0;
    protected byte[] m_chunk = null;
    protected int m_chunkCurPos = 0;

    public mbParser(String file) {
        this(file.toCharArray());
    }

    public mbParser(char[] file) {
        mbStream stream = new mbStream(file, 1);
        if (stream.error() != 0) {
            this.m_error = 1;
            return;
        }
        this.m_size = stream.size();
        this.m_chunk = new byte[(int)this.m_size];
        stream.readChunk(this.m_chunk, (int)this.m_size);
    }

    public void reset() {
        this.m_chunkCurPos = 0;
    }

    public double getDouble() {
        int i = this.m_chunkCurPos;
        double val = 0.0;
        while (this.m_chunk[i] < 48) {
            ++i;
        }
        while (this.m_chunk[i] < 58 && this.m_chunk[i] > 47 && this.m_chunk[i] != 46 && (long)i < this.m_size) {
            val *= 10.0;
            val += (double)(this.m_chunk[i] - 48);
            ++i;
        }
        if (this.m_chunk[i] == 46) {
            double tenth = 0.1;
            ++i;
            while (this.m_chunk[i] < 58 && this.m_chunk[i] > 47 && this.m_chunk[i] != 46 && (long)i < this.m_size) {
                val += ((double)this.m_chunk[i] - 48.0) * tenth;
                tenth *= 0.1;
                ++i;
            }
        }
        this.m_chunkCurPos = i;
        return val;
    }

    public float getFloat() {
        int i = this.m_chunkCurPos;
        float val = 0.0f;
        float sign = 1.0f;
        while (this.m_chunk[i] < 48 && (long)i < this.m_size) {
            ++i;
        }
        if (this.m_chunk[i - 1] == 45) {
            sign = -1.0f;
        }
        float tenth = 10.0f;
        while (this.m_chunk[i] < 58 && this.m_chunk[i] > 47 && this.m_chunk[i] != 46 && (long)i < this.m_size) {
            val *= tenth;
            val += (float)(this.m_chunk[i] - 48);
            ++i;
        }
        if (this.m_chunk[i] == 46) {
            tenth = 0.1f;
            ++i;
            while (this.m_chunk[i] < 58 && this.m_chunk[i] > 47 && this.m_chunk[i] != 46 && (long)i < this.m_size) {
                val += ((float)this.m_chunk[i] - 48.0f) * tenth;
                tenth *= 0.1f;
                ++i;
            }
        }
        this.m_chunkCurPos = i;
        return val * sign;
    }

    public int getInt() {
        int i = this.m_chunkCurPos;
        int val = 0;
        int sign = 1;
        if (this.m_error != 0) {
            return val;
        }
        while (this.m_chunk[i] < 48 && (long)i < this.m_size) {
            ++i;
        }
        if (this.m_chunk[i - 1] == 45) {
            sign = -1;
        }
        int tenth = 10;
        while (this.m_chunk[i] < 58 && this.m_chunk[i] > 47 && (long)i < this.m_size) {
            val *= tenth;
            val += this.m_chunk[i] - 48;
            ++i;
        }
        this.m_chunkCurPos = i;
        return val * sign;
    }

    public byte[] getString() {
        int i = this.m_chunkCurPos;
        int length = 0;
        while (this.m_chunk[i] < 33 && (long)i < this.m_size) {
            ++i;
        }
        while (this.m_chunk[i + length] > 32 && (long)i < this.m_size) {
            ++length;
            ++i;
        }
        byte[] s = new byte[length];
        System.arraycopy(this.m_chunk, i - length, s, 0, length);
        this.m_chunkCurPos = i;
        return s;
    }

    public void getString(byte[] s, int size) {
        int i = this.m_chunkCurPos;
        int length = 0;
        while (this.m_chunk[i] < 33 && (long)i < this.m_size) {
            ++i;
        }
        while (length < size && (long)i < this.m_size) {
            ++length;
            s[i] = this.m_chunk[i];
            ++i;
        }
        this.m_chunkCurPos = i;
    }

    public byte[] getLine() {
        int i = this.m_chunkCurPos;
        int length = 0;
        while (this.m_chunk[length] != 10 && (long)i < this.m_size) {
            ++length;
            ++i;
        }
        byte[] s = new byte[length];
        System.arraycopy(this.m_chunk, i - length, s, 0, length);
        this.m_chunkCurPos = i;
        return s;
    }

    public void getLine(char[] s, int size) {
    }

    public void skipLine() {
        int i = this.m_chunkCurPos;
        while ((long)i < this.m_size && this.m_chunk[i] != 10) {
            ++i;
        }
        this.m_chunkCurPos = i + 1;
    }

    public boolean find(String str) {
        return this.find(str.toCharArray());
    }

    public boolean find(char[] str) {
        int j = 0;
        int i = this.m_chunkCurPos;
        boolean found = false;
        while ((long)(i + str.length) < this.m_size) {
            if (this.m_chunk[i] == str[i - this.m_chunkCurPos]) {
                while (++j < str.length && this.m_chunk[i + j] == str[i - this.m_chunkCurPos + j]) {
                }
            }
            if (j == str.length) {
                this.m_chunkCurPos += j;
                found = true;
                break;
            }
            ++this.m_chunkCurPos;
            i = 0;
            j = 0;
        }
        return found;
    }

    public int position() {
        return this.m_chunkCurPos;
    }

    public void setPosition(int pos) {
        this.m_chunkCurPos = pos;
    }

    public int error() {
        return this.m_error;
    }
}

