/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Util;
import util.mbVec3;
import util.mbVec4;

public class mbMatrix4 {
    public float[] m = new float[16];

    public mbMatrix4() {
    }

    public mbMatrix4(float[] mat) {
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = mat[i];
        }
    }

    public mbMatrix4(mbMatrix4 mat) {
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i] = mat.m[i];
        }
    }

    public mbMatrix4(float m11, float m12, float m13, float m14, float m21, float m22, float m23, float m24, float m31, float m32, float m33, float m34, float m41, float m42, float m43, float m44) {
        this.m[0] = m11;
        this.m[1] = m12;
        this.m[2] = m13;
        this.m[3] = m14;
        this.m[4] = m21;
        this.m[5] = m22;
        this.m[6] = m23;
        this.m[7] = m24;
        this.m[8] = m31;
        this.m[9] = m32;
        this.m[10] = m33;
        this.m[11] = m34;
        this.m[12] = m41;
        this.m[13] = m42;
        this.m[14] = m43;
        this.m[15] = m44;
    }

    public mbMatrix4 clone() {
        return new mbMatrix4(this.m);
    }

    public float elementAt(int i) {
        return this.m[i];
    }

    public float[] array() {
        return this.m;
    }

    public mbMatrix4 mult(mbMatrix4 mat) {
        mbMatrix4 temp = new mbMatrix4();
        temp.m[0] = this.m[0] * mat.m[0] + this.m[4] * mat.m[1] + this.m[8] * mat.m[2] + this.m[12] * mat.m[3];
        temp.m[1] = this.m[1] * mat.m[0] + this.m[5] * mat.m[1] + this.m[9] * mat.m[2] + this.m[13] * mat.m[3];
        temp.m[2] = this.m[2] * mat.m[0] + this.m[6] * mat.m[1] + this.m[10] * mat.m[2] + this.m[14] * mat.m[3];
        temp.m[3] = this.m[3] * mat.m[0] + this.m[7] * mat.m[1] + this.m[11] * mat.m[2] + this.m[15] * mat.m[3];
        temp.m[4] = this.m[0] * mat.m[4] + this.m[4] * mat.m[5] + this.m[8] * mat.m[6] + this.m[12] * mat.m[7];
        temp.m[5] = this.m[1] * mat.m[4] + this.m[5] * mat.m[5] + this.m[9] * mat.m[6] + this.m[13] * mat.m[7];
        temp.m[6] = this.m[2] * mat.m[4] + this.m[6] * mat.m[5] + this.m[10] * mat.m[6] + this.m[14] * mat.m[7];
        temp.m[7] = this.m[3] * mat.m[4] + this.m[7] * mat.m[5] + this.m[11] * mat.m[6] + this.m[15] * mat.m[7];
        temp.m[8] = this.m[0] * mat.m[8] + this.m[4] * mat.m[9] + this.m[8] * mat.m[10] + this.m[12] * mat.m[11];
        temp.m[9] = this.m[1] * mat.m[8] + this.m[5] * mat.m[9] + this.m[9] * mat.m[10] + this.m[13] * mat.m[11];
        temp.m[10] = this.m[2] * mat.m[8] + this.m[6] * mat.m[9] + this.m[10] * mat.m[10] + this.m[14] * mat.m[11];
        temp.m[11] = this.m[3] * mat.m[8] + this.m[7] * mat.m[9] + this.m[11] * mat.m[10] + this.m[15] * mat.m[11];
        temp.m[12] = this.m[0] * mat.m[12] + this.m[4] * mat.m[13] + this.m[8] * mat.m[14] + this.m[12] * mat.m[15];
        temp.m[13] = this.m[1] * mat.m[12] + this.m[5] * mat.m[13] + this.m[9] * mat.m[14] + this.m[13] * mat.m[15];
        temp.m[14] = this.m[2] * mat.m[12] + this.m[6] * mat.m[13] + this.m[10] * mat.m[14] + this.m[14] * mat.m[15];
        temp.m[15] = this.m[3] * mat.m[12] + this.m[7] * mat.m[13] + this.m[11] * mat.m[14] + this.m[15] * mat.m[15];
        return temp;
    }

    public mbMatrix4 add(mbMatrix4 mat) {
        mbMatrix4 temp = new mbMatrix4();
        for (int i = 0; i < 16; ++i) {
            temp.m[i] = this.m[i] + mat.m[i];
        }
        return temp;
    }

    public mbMatrix4 sub(mbMatrix4 mat) {
        mbMatrix4 temp = new mbMatrix4();
        for (int i = 0; i < this.m.length; ++i) {
            temp.m[i] = this.m[i] - mat.m[i];
        }
        return temp;
    }

    public mbMatrix4 mult(float k) {
        mbMatrix4 temp = new mbMatrix4();
        for (int i = 0; i < 16; ++i) {
            temp.m[i] = this.m[i] * k;
        }
        return temp;
    }

    public mbMatrix4 div(float k) {
        mbMatrix4 temp = new mbMatrix4();
        for (int i = 0; i < 16; ++i) {
            temp.m[i] = this.m[i] / k;
        }
        return temp;
    }

    public mbVec3 multVec(mbVec3 v) {
        mbVec3 temp = new mbVec3();
        temp.x = this.m[0] * v.x + this.m[4] * v.y + this.m[8] * v.z + this.m[12];
        temp.y = this.m[1] * v.x + this.m[5] * v.y + this.m[9] * v.z + this.m[13];
        temp.z = this.m[2] * v.x + this.m[6] * v.y + this.m[10] * v.z + this.m[14];
        return temp;
    }

    public mbVec4 multVec(mbVec4 v) {
        mbVec4 temp = new mbVec4();
        temp.x = this.m[0] * v.x + this.m[4] * v.y + this.m[8] * v.z + this.m[12] * v.w;
        temp.y = this.m[1] * v.x + this.m[5] * v.y + this.m[9] * v.z + this.m[13] * v.w;
        temp.z = this.m[2] * v.x + this.m[6] * v.y + this.m[10] * v.z + this.m[14] * v.w;
        temp.w = this.m[3] * v.x + this.m[7] * v.y + this.m[11] * v.z + this.m[15] * v.w;
        return temp;
    }

    public void multMatrix(mbMatrix4 mat, mbMatrix4 res) {
        res.m[0] = this.m[0] * mat.m[0] + this.m[4] * mat.m[1] + this.m[8] * mat.m[2] + this.m[12] * mat.m[3];
        res.m[1] = this.m[1] * mat.m[0] + this.m[5] * mat.m[1] + this.m[9] * mat.m[2] + this.m[13] * mat.m[3];
        res.m[2] = this.m[2] * mat.m[0] + this.m[6] * mat.m[1] + this.m[10] * mat.m[2] + this.m[14] * mat.m[3];
        res.m[3] = this.m[3] * mat.m[0] + this.m[7] * mat.m[1] + this.m[11] * mat.m[2] + this.m[15] * mat.m[3];
        res.m[4] = this.m[0] * mat.m[4] + this.m[4] * mat.m[5] + this.m[8] * mat.m[6] + this.m[12] * mat.m[7];
        res.m[5] = this.m[1] * mat.m[4] + this.m[5] * mat.m[5] + this.m[9] * mat.m[6] + this.m[13] * mat.m[7];
        res.m[6] = this.m[2] * mat.m[4] + this.m[6] * mat.m[5] + this.m[10] * mat.m[6] + this.m[14] * mat.m[7];
        res.m[7] = this.m[3] * mat.m[4] + this.m[7] * mat.m[5] + this.m[11] * mat.m[6] + this.m[15] * mat.m[7];
        res.m[8] = this.m[0] * mat.m[8] + this.m[4] * mat.m[9] + this.m[8] * mat.m[10] + this.m[12] * mat.m[11];
        res.m[9] = this.m[1] * mat.m[8] + this.m[5] * mat.m[9] + this.m[9] * mat.m[10] + this.m[13] * mat.m[11];
        res.m[10] = this.m[2] * mat.m[8] + this.m[6] * mat.m[9] + this.m[10] * mat.m[10] + this.m[14] * mat.m[11];
        res.m[11] = this.m[3] * mat.m[8] + this.m[7] * mat.m[9] + this.m[11] * mat.m[10] + this.m[15] * mat.m[11];
        res.m[12] = this.m[0] * mat.m[12] + this.m[4] * mat.m[13] + this.m[8] * mat.m[14] + this.m[12] * mat.m[15];
        res.m[13] = this.m[1] * mat.m[12] + this.m[5] * mat.m[13] + this.m[9] * mat.m[14] + this.m[13] * mat.m[15];
        res.m[14] = this.m[2] * mat.m[12] + this.m[6] * mat.m[13] + this.m[10] * mat.m[14] + this.m[14] * mat.m[15];
        res.m[15] = this.m[3] * mat.m[12] + this.m[7] * mat.m[13] + this.m[11] * mat.m[14] + this.m[15] * mat.m[15];
    }

    public void multArray(float[] array, int offset, int size, int stride) {
        block3: {
            block2: {
                if (stride <= 2) break block2;
                for (int i = offset; i < size; i += stride) {
                    float x = array[i + 0];
                    float y = array[i + 1];
                    float z = array[i + 2];
                    array[i + 0] = this.m[0] * x + this.m[4] * y + this.m[8] * z + this.m[12];
                    array[i + 1] = this.m[1] * x + this.m[5] * y + this.m[9] * z + this.m[13];
                    array[i + 2] = this.m[2] * x + this.m[6] * y + this.m[10] * z + this.m[14];
                }
                break block3;
            }
            if (stride != 4) break block3;
            for (int i = offset; i < size; i += stride) {
                float x = array[i + 0];
                float y = array[i + 1];
                array[i + 0] = this.m[0] * x + this.m[4] * y + this.m[12];
                array[i + 1] = this.m[1] * x + this.m[5] * y + this.m[13];
            }
        }
    }

    public void identity() {
        this.m[15] = 1.0f;
        this.m[10] = 1.0f;
        this.m[5] = 1.0f;
        this.m[0] = 1.0f;
        this.m[4] = 0.0f;
        this.m[3] = 0.0f;
        this.m[2] = 0.0f;
        this.m[1] = 0.0f;
        this.m[9] = 0.0f;
        this.m[8] = 0.0f;
        this.m[7] = 0.0f;
        this.m[6] = 0.0f;
        this.m[14] = 0.0f;
        this.m[13] = 0.0f;
        this.m[12] = 0.0f;
        this.m[11] = 0.0f;
    }

    public void loadTranslation(float x, float y, float z) {
        this.identity();
        this.m[12] = x;
        this.m[13] = y;
        this.m[14] = z;
    }

    public void loadRotation(float rot, float x, float y, float z) {
        if (x != 0.0f || y != 0.0f || z != 0.0f) {
            float inv = (float)(1.0 / Math.sqrt(Util.sqr(x) + Util.sqr(y) + Util.sqr(z)));
            float radAngle = rot * 0.5f * (float)Math.PI / 180.0f;
            float cosA = (float)Math.cos(radAngle);
            float sinA = (float)Math.sin(radAngle);
            float x2 = Util.sqr(x *= inv * sinA);
            float y2 = Util.sqr(y *= inv * sinA);
            float z2 = Util.sqr(z *= inv * sinA);
            this.m[0] = 1.0f - 2.0f * y2 - 2.0f * z2;
            this.m[1] = 2.0f * x * y + 2.0f * cosA * z;
            this.m[2] = 2.0f * x * z - 2.0f * cosA * y;
            this.m[3] = 0.0f;
            this.m[4] = 2.0f * x * y - 2.0f * cosA * z;
            this.m[5] = 1.0f - 2.0f * x2 - 2.0f * z2;
            this.m[6] = 2.0f * y * z + 2.0f * cosA * x;
            this.m[7] = 0.0f;
            this.m[8] = 2.0f * x * z + 2.0f * cosA * y;
            this.m[9] = 2.0f * y * z - 2.0f * cosA * x;
            this.m[10] = 1.0f - 2.0f * x2 - 2.0f * y2;
            this.m[11] = 0.0f;
            this.m[12] = 0.0f;
            this.m[13] = 0.0f;
            this.m[14] = 0.0f;
            this.m[15] = 1.0f;
        } else {
            this.identity();
        }
    }

    public void loadScale(float x, float y, float z) {
        this.identity();
        this.m[0] = x;
        this.m[5] = y;
        this.m[10] = z;
    }

    public void loadRotation(float alpha, float beta, float theta) {
        float tmp = alpha * (float)Math.PI / 180.0f;
        float ca = (float)Math.cos(tmp);
        float sa = (float)Math.sin(tmp);
        tmp = beta * (float)Math.PI / 180.0f;
        float cb = (float)Math.cos(tmp);
        float sb = (float)Math.sin(tmp);
        tmp = theta * (float)Math.PI / 180.0f;
        float ct = (float)Math.cos(tmp);
        float st = (float)Math.sin(tmp);
        this.identity();
        this.m[0] = ca * ct + sa * sb * st;
        this.m[4] = cb * st;
        this.m[8] = -sa * ct + ca * sb * st;
        this.m[1] = -ca * st + sa * sb * ct;
        this.m[5] = cb * ct;
        this.m[9] = sa * st + ca * sb * ct;
        this.m[2] = sa * cb;
        this.m[6] = -sb;
        this.m[10] = ca * cb;
    }

    public void loadOrthoProj(float l, float r, float b, float t, float n, float f) {
        this.m[0] = 2.0f / (r - l);
        this.m[1] = 0.0f;
        this.m[2] = 0.0f;
        this.m[3] = 0.0f;
        this.m[4] = 0.0f;
        this.m[5] = 2.0f / (t - b);
        this.m[6] = 0.0f;
        this.m[7] = 0.0f;
        this.m[8] = 0.0f;
        this.m[9] = 0.0f;
        this.m[10] = -2.0f / (f - n);
        this.m[11] = 0.0f;
        this.m[12] = (r + l) / (r - l);
        this.m[13] = (t + b) / (t - b);
        this.m[14] = (f + n) / (f - n);
        this.m[15] = 1.0f;
    }

    public void loadPerspProj(float l, float r, float b, float t, float n, float f) {
        this.m[0] = 2.0f * n / (r - l);
        this.m[1] = 0.0f;
        this.m[2] = 0.0f;
        this.m[3] = 0.0f;
        this.m[4] = 0.0f;
        this.m[5] = 2.0f * n / (t - b);
        this.m[6] = 0.0f;
        this.m[7] = 0.0f;
        this.m[8] = (r + l) / (r - l);
        this.m[9] = (t + b) / (t - b);
        this.m[10] = -(f + n) / (f - n);
        this.m[11] = -1.0f;
        this.m[12] = 0.0f;
        this.m[13] = 0.0f;
        this.m[14] = -2.0f * f * n / (f - n);
        this.m[15] = 0.0f;
    }

    public void loadLookAt(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        mbVec3 up = new mbVec3(upX, upY, upZ);
        mbVec3 center = new mbVec3(centerX, centerY, centerZ);
        mbVec3 eye = new mbVec3(eyeX, eyeY, eyeZ);
        mbVec3 zAxis = eye.sub(center).normalize();
        mbVec3 xAxis = up.cross(zAxis).normalize();
        mbVec3 yAxis = zAxis.cross(xAxis);
        mbVec4 bottom = new mbVec4(0.0f, 0.0f, 0.0f, 1.0f);
        this.loadRow(xAxis, 1);
        this.loadRow(yAxis, 2);
        this.loadRow(zAxis, 3);
        this.loadRow(bottom, 4);
        this.loadColumn(new mbVec3(-xAxis.dot(eye), -yAxis.dot(eye), -zAxis.dot(eye)), 4);
    }

    public void loadLookAt(mbVec3 eye, mbVec3 center, mbVec3 up) {
        this.loadLookAt(eye.x, eye.y, eye.z, center.x, center.y, center.z, up.x, up.y, up.z);
    }

    public void loadRow(mbVec4 v, int row) {
        switch (row) {
            case 1: {
                this.m[0] = v.x;
                this.m[4] = v.y;
                this.m[8] = v.z;
                this.m[12] = v.w;
                break;
            }
            case 2: {
                this.m[1] = v.x;
                this.m[5] = v.y;
                this.m[9] = v.z;
                this.m[13] = v.w;
                break;
            }
            case 3: {
                this.m[2] = v.x;
                this.m[6] = v.y;
                this.m[10] = v.z;
                this.m[14] = v.w;
                break;
            }
            case 4: {
                this.m[3] = v.x;
                this.m[7] = v.y;
                this.m[11] = v.z;
                this.m[15] = v.w;
            }
        }
    }

    public void loadRow(mbVec3 v, int row) {
        switch (row) {
            case 1: {
                this.m[0] = v.x;
                this.m[4] = v.y;
                this.m[8] = v.z;
                break;
            }
            case 2: {
                this.m[1] = v.x;
                this.m[5] = v.y;
                this.m[9] = v.z;
                break;
            }
            case 3: {
                this.m[2] = v.x;
                this.m[6] = v.y;
                this.m[10] = v.z;
                break;
            }
            case 4: {
                this.m[3] = v.x;
                this.m[7] = v.y;
                this.m[11] = v.z;
            }
        }
    }

    public void loadColumn(mbVec4 v, int column) {
        switch (column) {
            case 1: {
                this.m[0] = v.x;
                this.m[1] = v.y;
                this.m[2] = v.z;
                this.m[3] = v.w;
                break;
            }
            case 2: {
                this.m[4] = v.x;
                this.m[5] = v.y;
                this.m[6] = v.z;
                this.m[7] = v.w;
                break;
            }
            case 3: {
                this.m[8] = v.x;
                this.m[9] = v.y;
                this.m[10] = v.z;
                this.m[11] = v.w;
                break;
            }
            case 4: {
                this.m[12] = v.x;
                this.m[13] = v.y;
                this.m[14] = v.z;
                this.m[15] = v.w;
            }
        }
    }

    public void loadColumn(mbVec3 v, int column) {
        switch (column) {
            case 1: {
                this.m[0] = v.x;
                this.m[1] = v.y;
                this.m[2] = v.z;
                break;
            }
            case 2: {
                this.m[4] = v.x;
                this.m[5] = v.y;
                this.m[6] = v.z;
                break;
            }
            case 3: {
                this.m[8] = v.x;
                this.m[9] = v.y;
                this.m[10] = v.z;
                break;
            }
            case 4: {
                this.m[12] = v.x;
                this.m[13] = v.y;
                this.m[14] = v.z;
            }
        }
    }
}

