/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Iterator;

public class mbList<T>
implements Iterable<T> {
    protected element<T> _head = new element();
    protected int _size = 0;

    public mbList() {
        this._head.prev = this._head;
        this._head.next = this._head.prev;
    }

    public void push_back(T data) {
        element nnode = new element(this._head.prev, this._head, data);
        this._head.prev.next = nnode;
        this._head.prev = nnode;
        ++this._size;
    }

    public void push_front(T data) {
        element<T> nnode = new element<T>(this._head, this._head.next, data);
        this._head.next.prev = nnode;
        this._head.next = nnode;
        ++this._size;
    }

    public void pop_back() {
        iterator<T> i = this.end();
        i.dec();
        this.erase(i);
    }

    public void pop_front() {
        this.erase(this.begin());
    }

    public void insert(iterator<T> i, T data) {
        element<T> elem = i.ielem();
        element nnode = new element(elem.prev, elem, data);
        elem.prev = nnode;
        nnode.prev.next = nnode;
        ++this._size;
    }

    public void clear() {
        while (this._head.next != this._head) {
            element temp = this._head.next;
            this._head.next = temp.next;
        }
        this._size = 0;
    }

    public iterator<T> begin() {
        return new iterator(this._head.next);
    }

    public iterator<T> end() {
        return new iterator<T>(this._head);
    }

    public iterator<T> erase(iterator<T> i) {
        element<T> elem = i.inc().ielem();
        if (elem != this._head) {
            elem.prev.next = elem.next;
            elem.next.prev = elem.prev;
            --this._size;
        }
        return i;
    }

    public int size() {
        return this._size;
    }

    mbList<T> addAll(mbList<T> l) {
        if (this != l) {
            this.clear();
            iterator<T> j = l.begin();
            while (j != l.end()) {
                this.push_back(j.data());
                j.inc();
            }
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return new listIterator();
    }

    private class listIterator
    implements Iterator<T> {
        iterator<T> iter;

        private listIterator() {
            this.iter = new iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter != mbList.this.end();
        }

        @Override
        public T next() {
            Object next = this.iter.ielem().data;
            this.iter.inc();
            return next;
        }

        @Override
        public void remove() {
            mbList.this.erase(this.iter);
        }
    }

    public class iterator<T> {
        protected element<T> _ptr = null;

        public iterator() {
        }

        public iterator(element<T> ptr) {
            this._ptr = ptr;
        }

        public element<T> ielem() {
            return this._ptr;
        }

        public iterator<T> inc() {
            this._ptr = this._ptr.next;
            return this;
        }

        public iterator<T> dec() {
            this._ptr = this._ptr.prev;
            return this;
        }

        public T data() {
            return this._ptr.data;
        }

        public boolean equals(iterator<T> i) {
            return this._ptr == i._ptr;
        }

        public boolean notEquals(iterator<T> i) {
            return !this.equals(i);
        }
    }

    public class element<T> {
        public element<T> prev;
        public element<T> next;
        public T data;

        public element(element<T> _prev, element<T> _next, T _data) {
            this.prev = _prev;
            this.next = _next;
            this.data = _data;
        }

        public element() {
        }
    }
}

